/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tcp;

import java.io.*;
import java.net.*;
import java.util.*;

public class DictionaryMultiServer {

    private static Dictionary dico = new Hashtable();

    public static void main(String[] args) {
        ServerSocket connectionServer = null;
        Socket clientSession = null;

        dico.put("object", "objet");
        dico.put("class", "classe");
        dico.put("inheritance", "heritage");
        dico.put("distributed", "reparti");

        try {
            connectionServer = new ServerSocket(4443);
            while (true) {
                clientSession = connectionServer.accept();
                new ClientSessionThread(clientSession, dico).start();
            }

        } catch (IOException e) {
            System.out.println(e);
            System.exit(1);
        }
    }
}

class ClientSessionThread extends Thread {

    Socket clientSession;
    Dictionary dico;

    ClientSessionThread(Socket clientSession, Dictionary dico) {
        this.clientSession = clientSession;
        this.dico = dico;
    }

    @Override
    public void run() {
        try {
            PrintWriter out = new PrintWriter(clientSession.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(clientSession.getInputStream()));
            String word, mot;

            System.out.println("New client session opened.");
            while ((word = in.readLine()) != null) {
                mot = (String) dico.get(word);
                if (mot == null) {
                    mot = "sorry, no translation available for \"" + word + "\" !";
                }
                out.println(mot);
            }
            out.close();
            in.close();
            clientSession.close();
            System.out.println("Client session closed.");
        } catch (IOException e) {
            System.out.println(e);
            System.exit(1);
        }
    }
}
